/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.entity;

import net.jayjay.dangerzone.entity.Entity;
import net.jayjay.dangerzone.entity.model.ModelDynamite;
import net.jayjay.dangerzone.sound.Sound;
import net.jayjay.dangerzone.src.Explosion;
import net.jayjay.dangerzone.texture.Textures;
import net.jayjay.dangerzone.world.World;
import org.lwjgl.opengl.GL11;

public class EntityDynamite
extends Entity {
    private float explosionDamage;
    private boolean hasExploded = false;
    private static ModelDynamite dynamiteModel = new ModelDynamite();
    private float dx;
    private float dy;
    private float dz;

    public EntityDynamite(World world, float x, float y, float z, float explosionDamage) {
        this(world, x, y, z, explosionDamage, 0.0f, 0.0f, 0.0f);
    }

    public EntityDynamite(World world, float x, float y, float z, float explosionDamage, float dx, float dy, float dz) {
        super(world);
        this.explosionDamage = explosionDamage;
        this.texture = "/entityDynamite.png";
        this.setSize(0.5f, 0.5f);
        this.setPos(x, y - 1.0f, z);
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
    }

    @Override
    public void tick() {
        super.tick();
        this.dy -= 0.04f;
        this.move(this.dx, this.dy, this.dz);
        if (!this.hasExploded && (this.onGround || this.collidedX || this.collidedZ || this.collidedY)) {
            this.explode();
            return;
        }
        this.dx *= 0.98f;
        this.dy *= 0.98f;
        this.dz *= 0.98f;
    }

    private void explode() {
        if (this.hasExploded) {
            return;
        }
        this.hasExploded = true;
        Sound.playDZ2Sound("explosion");
        Explosion.raycastExplosion(this.world, this.explosionDamage, this.x, this.y, this.z);
        this.remove();
    }

    @Override
    public void remove() {
        this.removed = true;
    }

    @Override
    public void render(float a2) {
        GL11.glEnable(3553);
        Textures.bindNearest(this.texture);
        GL11.glPushMatrix();
        GL11.glTranslatef(this.xo + (this.x - this.xo) * a2, this.yo + (this.y - this.yo) * a2, this.zo + (this.z - this.zo) * a2);
        GL11.glScalef(1.0f, -1.0f, 1.0f);
        float size = 0.058333334f;
        GL11.glScalef(size, size, size);
        double time = (double)System.nanoTime() / 1.0E9 * 10.0;
        float yy = (float)(-Math.abs(Math.sin(time * 0.6662)) * 2.0);
        GL11.glTranslatef(0.0f, yy, 0.0f);
        if (Math.abs(this.dx) > 0.01f || Math.abs(this.dz) > 0.01f) {
            float rot = (float)Math.atan2(this.dz, this.dx) * 57.29578f - 90.0f;
            GL11.glRotatef(rot, 1.0f, 1.0f, 1.0f);
        }
        dynamiteModel.render((float)time);
        GL11.glPopMatrix();
        GL11.glDisable(3553);
    }
}

